require "behaviours/wander"
require "behaviours/faceentity"
require "behaviours/chaseandattack"
require "behaviours/panic"
require "behaviours/follow"
require "behaviours/chattynode"
require "behaviours/attackwall"
require "behaviours/standstill"

local dutyaibrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local MIN_FOLLOW_DIST = 0
local TARGET_FOLLOW_DIST = 4
local MAX_FOLLOW_DIST = 6

local START_FACE_DIST = 6
local KEEP_FACE_DIST = 8

local KEEP_WORKING_DIST = 15
local SEE_WORK_DIST = 15

local RUN_AWAY_DIST = 5
local STOP_RUN_AWAY_DIST = 8

local RUN_AWAY_EPIC = 5
local RUN_AWAY_EPIC_STOP = 10 

local STOP_RUN_DIST = 8
local MAX_CHASE_TIME = 10
local MAX_WANDER_DIST = 4

local MAX_CHASE_DIST = 15
local TRADE_DIST = 20
local SEE_TREE_DIST = 15
local SEE_TARGET_DIST = 20


local AVOID_EXPLOSIVE_DIST = 5

local LEASH_RETURN_DIST = 7
local LEASH_MAX_DIST = 7

local DIG_TAGS = { "stump", "grave" }

local DUTYAI_TALK_MINE = {"Got to get paid somehow.", "Let me help with that.", "Safer money than navigating through a anamoly."}
local DUTYAI_TALK_CHOP = {"Let's get this tree down faster.", "I'm on it!", "Let me help with that."}
local DUTYAI_TALK_ATTACK = {"Engaging!", "Hostile spotted!","Die scum!", "Open fire!"}
local DUTYAI_TALK_EXPLOSIVE = {"Explosives! MOVE!", "Get out of there!", "Move! Move! Move!"}
local DUTYAI_TALK_DIG = {"Roger.", "Are we going to make some trenches?", "Got it!"}
local DUTYAI_TALK_HAMMER = {"Bring it down!", "It'll stand no longer!", "Got it!"}
local DUTYEXOAI_TALK_HIDE = {"Hiding!", "Out of sight."}
local DUTYAI_TALK_HACK = {"Cut it up!", "I'm on it!", "Let me help with that."}

local function GetTraderFn(inst)
    local x, y, z = inst.Transform:GetWorldPosition()
    local players = FindPlayersInRange(x, y, z, TRADE_DIST, true)
    for i, v in ipairs(players) do
        if inst.components.trader:IsTryingToTradeWithMe(v) then
            return v
        end
    end
end

local function KeepTraderFn(inst, target)
    return inst.components.trader:IsTryingToTradeWithMe(target)
end

local function GetLeader(inst)
    return inst.components.follower.leader
end


local function GetFaceTargetFn(inst)
    return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
   return inst.components.follower.leader == target
end

local function GetWanderPosition(inst)
	if inst.components.follower and inst.components.follower.leader then
		return Point(inst.components.follower.leader.Transform:GetWorldPosition())
	end
end

local function HasStateTags(inst, tags)
    for i, v in ipairs(tags) do
        if inst.sg:HasStateTag(v) then
            return true
        end
    end
end

local function KeepWorkingAction(inst, actiontags)
    return inst.components.follower.leader ~= nil
        and inst.components.follower.leader:IsNear(inst, KEEP_WORKING_DIST)
        and HasStateTags(inst.components.follower.leader, actiontags)
end

local function StartWorkingCondition(inst, actiontags)
    return inst.components.follower.leader ~= nil
        and HasStateTags(inst.components.follower.leader, actiontags)
        and not HasStateTags(inst, actiontags)
end

local function FindObjectToWorkAction(inst, action)
    if inst.sg:HasStateTag("working") then
        return
    end
    local target = FindEntity(inst.components.follower.leader, SEE_WORK_DIST, function(item) return item.components.workable and item.components.workable.action == action end)
    return target ~= nil
        and BufferedAction(inst, target, action)
        or nil
end

local function GetLeader(inst)
    return inst.components.follower.leader
end

local function GetFaceTargetFn(inst)
    local target = GetClosestInstWithTag("player", inst, START_FACE_DIST)
    return target ~= nil and not target:HasTag("notarget") and target or nil
end

local function KeepFaceTargetFn(inst, target)
    return not target:HasTag("notarget") and inst:IsNear(target, KEEP_FACE_DIST)
end

local function ShouldRunAwayEasy(inst)
    return FindEntity(inst, RUN_AWAY_DIST, nil, nil, {"bearded", "duty", "loner", "mithrarin", "truce", "boomerangbuilder", "dismantler", "fireblooded", "clearsky", "USS"}, {"monster", "hostile", "freedom", "monolith", "bandit", "frog"})
end

local function hide(inst)
    inst:PushEvent("hide")
end

local function KeepDiggingAction(inst)
    return  (inst.components.follower.leader ~= nil and
            inst:IsNear(inst.components.follower.leader, KEEP_WORKING_DIST, nil, { action.id.."_workable" }, { "INLIMBO" }))
end

local function StartDiggingCondition(inst)
    return  (inst.components.follower.leader ~= nil and
            inst.components.follower.leader.sg ~= nil and
            inst.components.follower.leader.sg:HasStateTag("digging"))
end

local function FindDigAction(inst, action)
    local target = FindEntity(inst, KEEP_WORKING_DIST, nil, { "DIG_workable" }, { "cattoy", "INLIMBO", "witherable" })
		return target ~= nil
        and BufferedAction(inst, target, ACTIONS.DIG)
		or nil
    end

-- local function facepalm(inst)
    -- inst:PushEvent("doh")
-- end

-- local function wave(inst)
    -- inst:PushEvent("wave")
-- end

function dutyaibrain:OnStart()
        local root = PriorityNode(
    {
			RunAway(self.inst, "epic", RUN_AWAY_EPIC, RUN_AWAY_EPIC_STOP),
			
			ChattyNode(self.inst,DUTYAI_TALK_ATTACK,
				ChaseAndAttack(self.inst, 5)),
						
						RunAway(self.inst, ShouldRunAwayEasy, RUN_AWAY_DIST, STOP_RUN_AWAY_DIST),
						
		--RunAway(self.inst, { fn = ShouldRunAway, oneoftags = { "monster", "hostile", "freedom", "monolith", "bandit"}, notags = { "INLIMBO", "truce" } }, RUN_AWAY_DIST, STOP_RUN_AWAY_DIST),
						
						ChattyNode(self.inst, DUTYEXOAI_TALK_HIDE,
			WhileNode( function() return GetLeader(self.inst) and GetLeader(self.inst).sg and GetLeader(self.inst).sg:HasStateTag("hiding") end, "hide",
				DoAction(self.inst, hide, "hide", false) )),
						
        WhileNode(function()
                return StartWorkingCondition(self.inst, { "chopping", "prechop" })
                    and KeepWorkingAction(self.inst, { "chopping", "prechop" })
            end,
            "keep chopping",
            ChattyNode(self.inst,DUTYAI_TALK_CHOP,DoAction(self.inst, function() return FindObjectToWorkAction(self.inst, ACTIONS.CHOP) end))),
			
		
        WhileNode(function()
                return StartWorkingCondition(self.inst, { "mining", "premine" })
                    and KeepWorkingAction(self.inst, { "mining", "premine" })
            end,
            "keep mining",
            ChattyNode(self.inst,DUTYAI_TALK_MINE,DoAction(self.inst, function() return FindObjectToWorkAction(self.inst, ACTIONS.MINE) end))),
			
			WhileNode(function()
				return StartDiggingCondition(self.inst, { "digging", "predig" }) 
				and KeepWorkingAction(self.inst, { "digging", "predig" }) 
				end,
				"keep digging",
				ChattyNode(self.inst, DUTYAI_TALK_DIG, DoAction(self.inst, function() return FindDigAction(self.inst, ACTIONS.DIG, DIG_TAGS) end))),	
				
				WhileNode(function()
				return StartWorkingCondition(self.inst, { "prehammer", "hammering" })
					and KeepWorkingAction(self.inst, { "prehammer", "hammering" })
			end,
			"keep hammering",
			ChattyNode(self.inst, DUTYAI_TALK_HAMMER, DoAction(self.inst, function() return FindObjectToWorkAction(self.inst, ACTIONS.HAMMER) end))),

				
			Follow(self.inst, GetLeader, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
		FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn),
		Wander(self.inst, GetWanderPosition, MAX_WANDER_DIST)
    }, .25)

    self.bt = BT(self.inst, root)
end


return dutyaibrain
